implementation module menuinternal


import	StdBool, StdTuple, StdMisc
import	osmenu
import	StdMenuElementClass
import	commondef, id, menuaccess, menucreate, menudefaccess, menudevice, menuevent, menuitems


::	DeltaMenuSystem l p
	:==	(MenuHandles (PSt l p)) -> *OSToolbox -> (MenuHandles (PSt l p),*OSToolbox)
::	AccessMenuSystem x ps
	:==	(MenuHandles ps) -> *OSToolbox -> (x,MenuHandles ps,*OSToolbox)
::	DeltaMenuHandles ps
	:==	[MenuStateHandle ps] -> *OSToolbox -> ([MenuStateHandle ps],*OSToolbox)
::	DeltaMenuHandle ps
	:==	(MenuStateHandle ps) -> *OSToolbox -> ( MenuStateHandle ps, *OSToolbox)


//	General rules to access MenuHandles:

changeMenuSystemState :: !Bool !(DeltaMenuSystem .l .p) !(IOSt .l .p) -> IOSt .l .p
changeMenuSystemState redrawMenus f ioState
	# (mDevice,ioState)	= IOStGetDevice MenuDevice ioState
	# (tb,ioState)		= getIOToolbox ioState
	  menus				= MenuSystemStateGetMenuHandles mDevice
	# (menus,tb)		= f menus tb
	  mDevice			= MenuSystemState menus
	# ioState			= IOStSetDevice mDevice ioState
	| not redrawMenus
		= setIOToolbox tb ioState
	# tb				= DrawMenuBar tb
	| otherwise
		= setIOToolbox tb ioState

accessMenuSystemState :: !Bool !(AccessMenuSystem x (PSt .l .p)) !(IOSt .l .p) -> (!x, !IOSt .l .p)
accessMenuSystemState redrawMenus f ioState
	# (mDevice,ioState)	= IOStGetDevice MenuDevice ioState
	# (tb,ioState)		= getIOToolbox ioState
	  menus				= MenuSystemStateGetMenuHandles mDevice
	# (x,menus,tb)		= f menus tb
	  mDevice			= MenuSystemState menus
	# ioState			= IOStSetDevice mDevice ioState
	| not redrawMenus
		= (x,setIOToolbox tb ioState)
	# tb				= DrawMenuBar tb
	| otherwise
		= (x,setIOToolbox tb ioState)


//	Closing a menu.

closemenu :: !Id !(IOSt .l .p) -> IOSt .l .p
closemenu id ioState
	# (mDevice,ioState)		= IOStGetDevice MenuDevice ioState
	  mHs					= MenuSystemStateGetMenuHandles mDevice
	  (menus,mHs)			= MenuHandlesGetMenuStateHandles mHs
	  (found,mH,menus)		= URemove (isMenuWithThisId id) undef menus
	| not found
		= IOStSetDevice (MenuSystemState {mHs & mMenus=menus}) ioState
	# (menu,mH)				= menuStateHandleGetHandle mH
	  (keys,osMenuBar,mHs)	= (\mHs=:{mKeys,mOSMenuBar}->(mKeys,mOSMenuBar,mHs)) mHs
	  keys					= filterShortcutkeys mH keys
	# (rt,ioState)			= IOStGetReceiverTable ioState
	# (ioid,ioState)		= IOStGetIOId ioState
	  rt					= closeMenuRIds ioid mH rt
	# ioState				= IOStSetReceiverTable rt ioState
	# (tb,ioState)			= getIOToolbox ioState
	# tb					= closeSubMenus mH tb
	# (osMenuBar,tb)		= OSMenuRemove menu osMenuBar tb
	# tb					= DrawMenuBar tb
	  mHs					= {mHs & mMenus=menus,mKeys=keys,mOSMenuBar=osMenuBar}
	# ioState				= setIOToolbox tb ioState
	# ioState				= IOStSetDevice (MenuSystemState mHs) ioState
	| otherwise
		= ioState
where
	isMenuWithThisId :: !Id !(MenuStateHandle .ps) -> (!Bool,!MenuStateHandle .ps)
	isMenuWithThisId id msH
		# (menuId,msH)	= menuStateHandleGetMenuId msH
		= (id==menuId,msH)


closeSubMenus :: !(MenuStateHandle .ps) !*OSToolbox -> *OSToolbox
closeSubMenus (MenuLSHandle {mlsHandle={mItems}}) tb
	= StateMap2 disposeSubMenuHandles mItems tb

closeMenuRIds :: !SystemId !(MenuStateHandle .ps) !ReceiverTable -> ReceiverTable
closeMenuRIds pid (MenuLSHandle {mlsHandle={mItems}}) rt
	= StateMap2 (disposeMenuRIds pid) mItems rt

filterShortcutkeys :: !(MenuStateHandle .ps) ![Char] -> [Char]
filterShortcutkeys (MenuLSHandle {mlsHandle={mItems}}) keys
	= StateMap2 disposeShortcutkeys mItems keys


//	Enabling and Disabling of Menus:

enablemenus :: ![Id] !(IOSt .l .p) -> IOSt .l .p
enablemenus ids ioState
	= changeMenuSystemState True (setSelectMenus ids Able) ioState

disablemenus :: ![Id] !(IOSt .l .p) -> IOSt .l .p
disablemenus ids ioState
	= changeMenuSystemState True (setSelectMenus ids Unable) ioState

setSelectMenus :: ![Id] !SelectState !(MenuHandles .ps) !*OSToolbox -> (!MenuHandles .ps,!*OSToolbox)
setSelectMenus ids select menus=:{mOSMenuBar,mEnabled,mMenus} tb
	# (_,msHs,tb)	= setSelectMenuHandles 0 select mOSMenuBar mEnabled ids mMenus tb
	= ({menus & mMenus=msHs},tb)
where	
	setSelectMenuHandles :: !Int !SelectState !OSMenuBar !Bool ![Id] ![MenuStateHandle .ps] !*OSToolbox
														   -> (![Id],![MenuStateHandle .ps],!*OSToolbox)
	setSelectMenuHandles zIndex select osMenuBar systemAble ids msHs tb
		| isEmpty ids || isEmpty msHs
			= (ids,msHs,tb)
		| otherwise
			# (msH,msHs)	= HdTl msHs
			# (ids,msH, tb)	= setSelectMenuHandle  zIndex     select osMenuBar systemAble ids msH  tb
			# (ids,msHs,tb)	= setSelectMenuHandles (zIndex+1) select osMenuBar systemAble ids msHs tb
			= (ids,[msH:msHs],tb)
	where
		setSelectMenuHandle :: !Int !SelectState !OSMenuBar !Bool ![Id] !(MenuStateHandle .ps) !*OSToolbox
															  -> (![Id], !MenuStateHandle .ps, !*OSToolbox)
		setSelectMenuHandle zIndex select osMenuBar systemAble ids msH=:(MenuLSHandle mlsH=:{mlsHandle=mH=:{mMenuId}}) tb
			# (containsId,ids)	= RemoveCheck mMenuId ids
			| not containsId
				= (ids,msH,tb)
			# msH				= MenuLSHandle {mlsH & mlsHandle={mH & mSelect=enabled select}}
			| not systemAble
				= (ids,msH,tb)
			| enabled select
				= (ids,msH,OSEnableMenu  zIndex osMenuBar tb)
				= (ids,msH,OSDisableMenu zIndex osMenuBar tb)


//	Removing menu elements from (sub/radio)menus:

closemenuelements :: !Id ![Id] !(IOSt .l .p) -> IOSt .l .p
closemenuelements mId ids ioState
	# (pid,ioState)	= IOStGetIOId ioState
	# (rt,ioState)	= IOStGetReceiverTable ioState
	# (rt,ioState)	= accessMenuSystemState True (removeMenusItems mId ids pid rt) ioState
	# ioState		= IOStSetReceiverTable rt ioState
	= ioState


//	Removing menu elements from (sub/radio)menus by index (counting from 1):

RemoveSpecialMenuElements	:==	True		// For closemenuindexelements:        remove elements with special ids
NotRemoveSpecialMenuElements:==	False		// For closemenuindexelements: do not remove elements with special ids

closemenuindexelements :: !Bool !Bool !(!Id,!Maybe Id) ![Index] !(IOSt .l .p) -> IOSt .l .p
closemenuindexelements removeSpecialElements fromRadioMenu loc indices ioState
	# (pid,ioState)	= IOStGetIOId ioState
	# (rt,ioState)	= IOStGetReceiverTable ioState
	# (rt,ioState)	= accessMenuSystemState True (removeMenusIndexItems removeSpecialElements fromRadioMenu loc indices pid rt) ioState
	# ioState		= IOStSetReceiverTable rt ioState
	= ioState


//	Set & Get the title of a menu.

setmenutitle :: !Id !Title !(IOSt .l .p) -> IOSt .l .p
setmenutitle id title ioState
	= changeMenuSystemState True (setOSMenuTitle id title) ioState
where
	setOSMenuTitle :: !Id !Title !(MenuHandles .ps) !*OSToolbox -> (!MenuHandles .ps,!*OSToolbox)
	setOSMenuTitle id title menus=:{mOSMenuBar,mMenus} tb
		# (msHs,tb)	= setOSMenusTitle id title mOSMenuBar mMenus tb
		= ({menus & mMenus=msHs},tb)
	where
		setOSMenusTitle :: !Id !Title !OSMenuBar ![MenuStateHandle .ps] !*OSToolbox -> (![MenuStateHandle .ps],!*OSToolbox)
		setOSMenusTitle id title osMenuBar [msH:msHs] tb
			# (menuId,msH)	= menuStateHandleGetMenuId msH
			| id==menuId
				# (mH,msH)	= menuStateHandleGetHandle msH
				  msH		= menuStateHandleSetTitle title msH
				# tb		= OSChangeMenuTitle osMenuBar mH title tb
				= ([msH:msHs],tb)
			| otherwise
				# (msHs,tb)	= setOSMenusTitle id title osMenuBar msHs tb
				= ([msH:msHs],tb)
		setOSMenusTitle _ _ _ msHs tb
			= (msHs,tb)
/*	PA: this is the Macintosh implementation. It has to destroy and completely rebuild the menu.
setmenutitle id title ioState
	# (mDevice,ioState)	= IOStGetDevice MenuDevice ioState
	  mHs				= MenuSystemStateGetMenuHandles mDevice
	  (menus,mHs)		= MenuHandlesGetMenuStateHandles mHs
	  (found,mH,insertpos,before,after)
						= removemenu id 0 menus
	| not found
		= IOStSetDevice (MenuSystemState {mHs & mMenus=before++after}) ioState
	# (osMenuNr,mH)		= menuStateHandleGetOSMenuNr mH
	  (oldmenu,mH)		= menuStateHandleGetHandle mH
	  (keys,mHs)		= (\mHs=:{mKeys}->(mKeys,mHs)) mHs
	  keys				= filterShortcutkeys mH keys
	# (activeIO,ioState)= IOStIsActive ioState
	# (tb,ioState)		= getIOToolbox ioState
	# (oldMenuSystem,tb)= checkCurrentMenuSystem activeIO tb
	# (mHs,tb)			= SetMenuSystem mHs tb
	# tb				= closeSubMenus mH  tb
	# tb				= DeleteMenu osMenuNr tb
	# tb				= DisposeMenu oldmenu tb
	# (mH,tb)			= reopenmenu title mH tb
	# (mH,keys,tb)		= reopenmenuitems  mH keys tb
	  (newmenu,mH)		= menuStateHandleGetHandle mH
	# tb				= InsertMenu newmenu insertpos tb
	  mHs				= {mHs & mMenus=before++[mH:after],mKeys=keys}
	# (mHs,tb)			= GetMenuSystem mHs tb
	# tb				= redrawOnlyActiveMenuSystem oldMenuSystem activeIO tb
	# ioState			= setIOToolbox tb ioState
	# ioState			= IOStSetDevice (MenuSystemState mHs) ioState
	| otherwise
		= ioState
where
	removemenu :: !Id !Int ![MenuStateHandle .ps] -> (!Bool,!MenuStateHandle .ps,!Int,![MenuStateHandle .ps],![MenuStateHandle .ps])
	removemenu id insertpos [mH:mHs]
		# (menu_id,mH)= menuStateHandleGetMenuId mH
		| id==menu_id
			= (True,   mH, insertpos, [],mHs)
		# (removed,mH1,insertpos,before,after) = removemenu id (insertpos+1) mHs
		| otherwise
			= (removed,mH1,insertpos,[mH:before],after)
	removemenu id insertpos _
		= (False,MenuLSHandle (dummy "SetMenuTitle"),insertpos,[],[])
	
	reopenmenu :: !Title !(MenuStateHandle .ps) !*OSToolbox -> (!MenuStateHandle .ps,!*OSToolbox)
	reopenmenu title mH tb
		# (select,mH)	= menuStateHandleGetSelect mH
		  (macId, mH)	= menuStateHandleGetMacId  mH
		# (menu,tb)		= NewMenu macId (validateMenuTitle title) tb
		  mH			= menuStateHandleSetHandle menu (menuStateHandleSetTitle title mH)
		| select
			= (mH,EnableItem  menu 0 tb)
			= (mH,DisableItem menu 0 tb)
	
	reopenmenuitems :: !(MenuStateHandle .ps) ![Char] !*OSToolbox
					-> (!MenuStateHandle .ps, ![Char],!*OSToolbox)
	reopenmenuitems (MenuLSHandle menuH=:{mlsHandle}) keys tb
		# (_,items,_,keys,tb)	= createMenuElements mlsHandle.mHandle 1 mlsHandle.mItems MacSubIds keys tb
		= (MenuLSHandle {menuH & mlsHandle={mlsHandle & mItems=items}},keys,tb)
*/